#!/usr/bin/env python

# ************************************************************************************
# pHAT-GSM modem test program
#
# Platform : Raspberry-Pi (any)    Core operating system : Any
#
# Python version : 2.7 minimum          Software version : 1.01.00
# ************************************************************************************

import subprocess
import time
from time import localtime, strftime
from datetime import datetime
import sys
import os
import RPi.GPIO as GPIO
import serial
from termcolor import colored

# General defines
TRUE = 1
FALSE = 0
ON = 1
OFF = 0

# Modem defines
MODEM_PORT = '/dev/ttySC0'
MODEM_BAUD = 115200
MODEM_ATCGMR = 'AT+CGMR'

# GPIO defines (BCM)
MDM_PWRON = 23

# Define global variables
bvalue = 0
wvalue = 0
svalue = ""

# Send AT command to modem and await a response
def SendAT(command):
        modem.flushInput()
        print (colored(('Modem send: ' + command + '\r'), 'red'))
        modem.write(str.encode(command + '\r'))
        return AwaitResponse()

# Await response from modem
def AwaitResponse():
        buf = "."
        timeout = time.time()
        while (buf == '.'  or buf == '\r\n') and buf != '':
                buf = modem.readline()
        print (colored(('Modem receive: ' + str(buf)), 'green'))
        return buf
        

# *************************************************************************************
# Main program entry
# *************************************************************************************

try:

        # Setup GPIO inputs and outputs
        GPIO.setmode(GPIO.BCM)
        GPIO.setup(MDM_PWRON, GPIO.OUT)
        GPIO.output(MDM_PWRON, OFF)
        print ('GPIO Initialised...\n')

        # Power up modem
        modem = serial.Serial(MODEM_PORT, baudrate=MODEM_BAUD, timeout=5)
        print ('Starting modem...\n')
        GPIO.output(MDM_PWRON, 1)
        time.sleep(1)
        GPIO.output(MDM_PWRON, 0)
        time.sleep(5)

        # Setup timers
        query_time=time.time()
        
        # Indicate system running
        print ('Tests running...\n')

        # Main program loop
        while True:

                current_time=time.time()
                
                # Every cycle look for async modem responses and process
                if modem.inWaiting():
                        modem_buffer = AwaitResponse()


                # Every 3 seconds send serial data
                if current_time > (query_time + 3):
                        query_time=time.time()

                        # Query modem
                        SendAT(MODEM_ATCGMR)
                        AwaitResponse()



# For ctrl-C or normal system exit then exit normally
except KeyboardInterrupt or SystemExit:
        GPIO.cleanup()
        modem.close()
        sys.exit(0)

# For any other errors get house in order just in case error was due to config and reboot
except Exception as e:
        print (str(e))
        GPIO.cleanup()
        modem.close()
        sys.exit(0)

